CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF  NOT EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'rc_cli_biometria') THEN 
		CREATE TABLE rc_cli_biometria
		(
		  cd_cli numeric(10,0) NOT NULL,
		  cd_emp numeric(10,0) NOT NULL DEFAULT 0,
		  biometria character varying(8000) DEFAULT ''::character varying,
		  CONSTRAINT rc_cli_biometria_pkey PRIMARY KEY (cd_cli, cd_emp),
		  CONSTRAINT rc_cli_biometria_fkey FOREIGN KEY (cd_cli, cd_emp)
			  REFERENCES rc_cli (cd_cli, cd_emp) MATCH SIMPLE
			  ON UPDATE NO ACTION ON DELETE NO ACTION
		)
		WITH (
		  OIDS=FALSE
		);
        RAISE NOTICE 'Operacao realizada com sucesso. Criada rc_cli_biometria.';
    ELSE 
		RAISE NOTICE 'Tabela rc_cli_biometria já existe.'; 
    END IF; 
	
	IF  NOT EXISTS (SELECT 1 FROM pg_catalog.pg_indexes 
					WHERE indexname = 'idx_rc_cli_biometria_emp_cli') THEN 
		CREATE INDEX idx_rc_cli_biometria_emp_cli ON rc_cli_biometria
		USING btree
		(cd_emp, cd_cli);
        RAISE NOTICE 'Operacao realizada com sucesso. Criada idx_rc_cli_biometria_emp_cli';
    ELSE 
		RAISE NOTICE 'Indice idx_rc_cli_biometria_emp_cli já existe.'; 
    END IF; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();

